/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.exceptions;

import com.ibm.hsc.common.exceptions.PIHscServerException;
import com.ibm.hsc.common.util.CmdExtendedErrorList;
import com.ibm.hsc.common.util.HardwareServerMessage;

public class PISystemException
extends PIHscServerException {
    private static final int EXTENDED_ERROR = 33006;
    private static final int HS_ERROR = -1;
    private String m_message = null;
    private int m_status = 0;
    private CmdExtendedErrorList m_eError = null;
    private Object m_secondaryStatusData = null;
    private HardwareServerMessage m_hsMessage = null;

    public PISystemException(String string, int n) {
        super("1400", new String[]{string, "" + n}, null);
        this.m_message = string;
        this.m_status = n;
    }

    public PISystemException(String string, CmdExtendedErrorList cmdExtendedErrorList) {
        super("1400", new String[]{string, cmdExtendedErrorList.toString()}, null);
        this.m_status = 33006;
        this.m_message = string;
        this.m_eError = cmdExtendedErrorList;
    }

    public PISystemException(String string, HardwareServerMessage hardwareServerMessage) {
        super("1400", new String[]{string, "" + hardwareServerMessage.getErrorCode()}, null);
        this.m_status = -1;
        this.m_message = string;
        this.m_hsMessage = hardwareServerMessage;
    }

    public PISystemException(String string, String[] stringArray, String string2, CmdExtendedErrorList cmdExtendedErrorList) {
        super(string, stringArray, null);
        this.m_status = 33006;
        this.m_message = string2;
        this.m_eError = cmdExtendedErrorList;
    }

    public boolean isExtendedError() {
        return this.m_status == 33006;
    }

    public boolean isHsError() {
        return this.m_status == -1;
    }

    public String getCommandMessage() {
        return this.m_message;
    }

    public int getStatus() {
        return this.m_status;
    }

    public void setStatus(int n) {
        this.m_status = n;
    }

    public CmdExtendedErrorList getExtendedError() {
        return this.m_eError;
    }

    public void setSecondaryStatusData(Object object) {
        this.m_secondaryStatusData = object;
    }

    public Object getSecondaryStatusData() {
        return this.m_secondaryStatusData;
    }

    public int getHsErrorCode() {
        if (this.m_hsMessage != null) {
            return this.m_hsMessage.getErrorCode();
        }
        return 0;
    }
}

